*-----------------------------------------------------------
* Program    :
* Written by :
* Date       :
* Description:	Dic
*-----------------------------------------------------------
*
	OFFSET	0
DicPrv	DS.L	1	* Ptr to prev Dic, 0 if first one
DicTyp	EQU	*	* Overload loworder 3 bits (mbz) of DicNm
DicTYMK	equ	$00000003
*			DicType Values
DicTYPSCALAR	equ	$00000000 * Long DicSclr is the data
DicTYPBINFN	equ	$00000001 * DicVec is @WdVec for code fn
DicTYPSYMFN	equ	$00000002 * DicVec is @ChVec for sym fn
DicTYPVEC	equ	$00000003 * DicVec is @Vec for multi-long data
DicNm	DS.L	1	* Null if anonymous, else ptr to ChVec of name
DicNMMK	equ	$fffffffc
DicSclr	Equ	*	* Long immediate data
DicVc	DS.L	1	* ptr to vector data
	ORG	*
*
*	================= DicPrev(v:VecPtr): DicPtr ===================
DicPrev:	* ALTERS a0 
	move.l	-MARKBYTS(a6),a0 * v
	move.l	(a0),(a6)	 * v^.prev overwrites result in situ
	rts
*
DicLast:	* just pushes DicLst
	move.l  a3,(a6)
	rts
*
*	================= DicType(v:VecPtr): Unsigned Long * DicTyp =====
DicType:	* ALTERS a0,d0 	* NmTyp set at New and not changed
	move.l	-MARKBYTS(a6),a0 * v
	move.l	#DicTYMK,d0
	and.l	DicTyp(a0),d0
	move.l	d0,(a6)		* v^.DicTyp overwrites result in situ
	rts
*
*	================= DicNmPtr(v:VecPtr): ChVecPtr =================
DicNmPtr:	* ALTERS a0,d0 * NmPtr set at New and not changed
	move.l	-MARKBYTS(a6),a0 * v
	move.l	#DicNMMK,d0
	and.l	DicNm(a0),d0
	move.l	d0,(a6)		 * v^.DicNm overwrites result in situ
	rts
*
*	================= DicScalVecP(v:vecPtr): long ==================

DicScalVecP:		* ALTERS a0 	* NmPtr set at New and not changed
	move.l	-MARKBYTS(a6),a0	* v
	move.l	DicVc(a0),(a6)		* v^.DicVc overwrites result in situ
	rts
*
*	================= DicSetScalVecP (v:vecPtr, x:long):long ========
DicSetScalVecP:		* ALTERS a0,d0; update scalar variables incl labels
	move.l	-(MARKBYTS+LNGBYTS)(a6),d0 * x
	move.l	-MARKBYTS(a6),a0	* v
	move.l	d0,DicVc(a0)		* v
	move.l	a0,(a6)			* overwrite result in place
	rts
*
*	========= DicNew(p: Prev, n:NmPtr, t: DicElTyp, v:VecPtr): DicPtr =====
DicNew:	* ALTERS a0,d0
	move.l	-MARKBYTS(a6),(a4)+ * Prev Ptr
	move.l	-(MARKBYTS+2*LNGBYTS)(a6),d0 * Eltype
	andi.l	#DicTYMK,d0	* Clear Highorder bits to not hit NmPtr
	move.l	-(MARKBYTS+LNGBYTS)(a6),d1 * NmPtr polluted w/ type
	andi.l	#DicNMMK,d1	* Clear eltyp bits in pointer
	or.l	d1,d0		* Merge NmPtr and Eltyp
	move.l	d0,(a4)+	* NmPtr set
	move.l	-(MARKBYTS+3*LNGBYTS)(a6),(a4)+	* VecPtr set
	lea.l	-(3*LNGBYTS)(a4),a3	* DicLst updated
	move.l	a3,(a6)		* Result is @ vector just built
	rts
*
*	=============== DicSrch(cp: ChVecPtr,start: DicPtr): DicPtr ==========
*\\	Returns Null if not found
DicSrch:
	OFFSET	0
_DS_Result	DS.L	1	* Result
_DS_OldFrm	DS.L	1	* Old Frame Ptr
_DS_cp		DS.L	1	* arg 1 is ChVecPtr to search for
_DS_start	DS.L	1
_DS_RetPC	DS.L	1	* Return PC
_DS_dp		DS.L	1	* dp : DicPtr
_DS_t		DS.L	1	* t : ChVecPtr
	ORG	*
*	dp=start
	move.l	-_DS_start(a6),-(a7)	* allocates dp, sets Z flg
*	while (dp <>null) do
DSwhile:
	beq	DSendlp
*    		t=DicNmPtr(dp); \\ dp known not null
		halfmark
			move.l	-_DS_dp(a6),-(a7) * dp
			lea.l	MARKBYTS(a7),a6 	  * new frm
			lea.l	DicNmPtr,a0
			jsr	(a0)
		unmark				  * tos is t
*    		if VecCmp(t,cp)=0 then
		halfmark	
			move.l	-_DS_t(a6),-(a7)  * t
			move.l  -_DS_cp(a6),-(a7) * cp
			lea.l	MARKBYTS+LNGBYTS(a7),a6 	  * new frm
			lea.l   VecCmp,a0
			jsr	(a0)
		unmark				  * -1,0,1 in tos, then t in tos-1
		tst.l	(a7)+			  * tos is t		  
		bne     DSelse
DSendlp:
*        		return dp
			move.l -_DS_dp(a6),(a6)
			move.l -_DS_RetPC(a6),a0
			jmp	(a0) 
*    		else
Dselse:
*        		dp =DicPrev(dp)
			halfmark
		          move.l -_DS_dp(a6),-(a7) * dp
			  lea.l	MARKBYTS(a7),a6	* new frm
			  lea.l	DicPrev,a0
			  jsr	(a0)
			unmark			* prev in tos, t in tos-1
		        move.l  (a7)+,-_DS_dp(a6) * dp updated set Z flg for beq at while
			lea.l	LNGBYTS(a7),a7	* pop t back off; no chg Z flg
*     		endif
*	endwhile 
	bra Dswhile
*
		ORG	(*+3)&-4	
*
*	=============================== Name Vectors ===========================
_DicPrev	DC.L	_StrNxtCh
		DC.W	8
		DC.W	7
		DC.B	'_DicPrv',0
*
_DicLast	DC.L	_DicPrev
		DC.W	8
		DC.W	7
		DC.B	'_DicLst',0
*
_SCALAR		DC.L	_DicLast
		DC.W	8
		DC.W	7
		DC.B	'_SCALAR',0
*
_BINFN		DC.L	_SCALAR
		DC.W	8
		DC.W	6
		DC.B	'_BINFN',0,0
*
_SYMFN		DC.L	_BINFN
		DC.W	8
		DC.W	6
		DC.B	'_SYMFN',0,0
*
_DATA		DC.L	_SYMFN
		DC.W	8
		DC.W	5
		DC.B	'_DATA',0,0,0
*
_DicType	DC.L	_DATA
		DC.W	12
		DC.W	8
		DC.B	'_DicType',0,0,0,0,0,0,0,0
*
_DicNmPtr	DC.L	_DicType
		DC.W	12
		DC.W	9
		DC.B	'_DicNmPtr',0,0,0,0,0,0,0
*
_DicScalVecP	DC.L	_DicNmPtr
		DC.W	12
		DC.W	12
		DC.B	'_DicScalVecP',0,0,0,0
*
_DicSetScalVecP	DC.L	_DicScalVecP
		DC.W	12
		DC.W	15
		DC.B	'_DicSetScalVecP',0
*
_DicNew		DC.L	_DicSetScalVecP
		DC.W	8
		DC.W	7
		DC.B	'_DicNew',0
*
_DicSrch	DC.L	_DicNew
		DC.W	12
		DC.W	8
		DC.B	'_DicSrch',0,0,0,0,0,0,0,0
*
*	========================= Dic Entries ==============================
*
__DicPrev	DC.L	__StrNxtCh
		DC.L	_DicPrev
		DC.L	DicPrev
*
__DicLast	DC.L	__DicPrev
		DC.L	_DicLast
		DC.L	DicLast
*
__SCALAR	DC.L	__DicLast
		DC.L	_SCALAR
		DC.L	DicTYPSCALAR
*
__BINFN		DC.L	__SCALAR
		DC.L	_BINFN
		DC.L	DicTYPBINFN
*
__SYMFN		DC.L	__BINFN
		DC.L	_SYMFN
		DC.L	DicTYPSYMFN
*
__DATA		DC.L	__SYMFN
		DC.L	_DATA
		DC.L	DicTYPVEC
*
__DicType	DC.L	__DATA
		DC.L	_DicType
		DC.L	DicType
*
__DicNmPtr	DC.L	__DicType
		DC.L	_DicNmPtr
		DC.L	DicNmPtr
*
__DicScalVecP	DC.L	__DicNmPtr
		DC.L	_DicScalVecP
		DC.L	DicScalVecP
*
__DicSetScalVecP DC.L	__DicScalVecP
		DC.L	_DicSetScalVecP
		DC.L	DicSetScalVecP
*
__DicNew	DC.L	__DicSetScalVecP
		DC.L	_DicNew
		DC.L	DicNew
*
__DicSrch	DC.L	__DicNew
		DC.L	_DicSrch
		DC.L	DicSrch
*

	












































*~Font name~Courier New~
*~Font size~10~
*~Tab type~1~
*~Tab size~8~
